<?php
include('../includes/session.php');
include('../includes/config.php');
include('../template/tngweb/header.php');
$fee    = $udata['mobile_to_msme_udyam_fee'];
checkServiceStatus($udata, 'mobile_to_msme_udyam_fee_status');

$sampleCode = '';
$resdata = [];

if ($_POST['mobileNumber']) {
    $mobileNumber = trim($_POST['mobileNumber']);
    $appliedby = $udata['phone'];

    if ($udata['balance'] >= $fee) {
        $request = [
        'mobileNumber' => $mobileNumber,
        ];

        $resdata = mobile_number_to_msme_udyam_verification_api_run($request);

        $errore = $resdata['error'] ?? '';
        $sampleCode = $resdata['sampleCode'] ?? '';

        
        if (!empty($errore)) {
            echo '<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
            <script>
                Swal.fire({
                    icon: "error",
                    title: "Error",
                    text: "' . addslashes($errore) . '",
                    timer: 5000,
                    timerProgressBar: true
                }).then(() => { window.location = ""; });
            </script>';
        }
       
        elseif ((string)$sampleCode === "200" || (int)$sampleCode === 200) {
            $debit_fee = $udata['balance'] - $fee;
            $parentPhone = $udata['parent'] ?? null;

         
            addCommission($tng_conn, $appliedby, $fee, $parentPhone, "Mobile Number to Msme Udyam Find Verification");

            
            mysqli_query($tng_conn, "UPDATE users SET balance=balance-$fee WHERE phone='$appliedby'");

           
            mysqli_query($tng_conn, "INSERT INTO `wallethistory`(`userid`, `amount`, `balance`, `purpose`, `status`, `type`) 
                VALUES ('$appliedby','$fee','$debit_fee','Mobile Number to Msme Udyam Find Verification','1','Debit')");

            echo '<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
            <script>
                Swal.fire({
                    icon: "success",
                    title: "Success",
                    text: "Msme Udyam details fetched successfully!",
                    timer: 3000,
                    timerProgressBar: true
                });
            </script>';
        }
        else {
            echo '<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
            <script>
                Swal.fire({
                    icon: "error",
                    title: "Something went wrong",
                    text: "Unable to fetch Msme Udyam details.",
                    timer: 3000,
                    timerProgressBar: true
                }).then(() => { window.location = ""; });
            </script>';
        }

    } else {
        echo '<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
        <script>
            Swal.fire({
                icon: "error",
                title: "Wallet Balance is Low!",
                text: "Please Recharge Now!",
                timer: 2000,
                timerProgressBar: true
            }).then(() => { window.location = "wallet.php"; });
        </script>';
    }
}
?>

<div class="page-wrapper">
    <div class="page-content">
        <div class="mobile-menu-overlay"></div>
        <div class="main-container">
            <div class="col-lg-12">
                <div class="card" style="margin-left: 10px; padding-left: 30px; padding-top: 12px; box-shadow: 1px 5px 5px 5px;">
                    <div class="stat-widget-two">
                        <div class="stat-content">
                            <div class="stat-text">
                                <div class="container-fluid">
                                    <div class="row">
                                      
                                        <div class="col-lg-4 col-md-6 col-sm-6">
                                            <div class="card">
                                                <div class="card-body">
                                                        <div class="mb-4">
        <a href="javascript:history.back()" class="back-btn">
            <i class="bi bi-arrow-left-circle"></i> Go Back
        </a>
    </div>
                                                    <div class="alert alert-primary" role="alert">
                                                        Mobile Number to Msme Udyam Check
                                                    </div>
                                                    <form action="" method="POST" class="row g-3">
                                                        <div class="card-body">
                                                            <div class="col-md-12">
                                                                <div class="form-group">
                                                                    <label for="mobileNumber">Enter Mobile Number</label>
                                                                    <input name="mobileNumber" type="text" id="mobileNumber" maxlength="10" minlength="10" placeholder="Enter Valid Mobile Number" class="form-control" required>
                                                                </div>
                                                                <hr>
                                                                <div class="row mt-3">
                                                                    <div class="col-md-6">
                                                                        <input class="form-control" value="Fee ₹ <?php echo $fee; ?>" readonly>
                                                                    </div>
                                                                    <div class="col-md-6 text-end">
                                                                        <button class="btn btn-success" name="submit" id="submit"><i class="fa fa-check-circle"></i> Submit</button>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>

                                       
                                        <?php if (!empty($resdata) && ((string)$sampleCode === "200" || (int)$sampleCode === 200)) { ?>
                                        <div class="col-lg-8 col-md-6 col-sm-6">
                                            <div class="card" style="background-color: #FCF3CF;" id="printSection">
                                                <div class="card-body">
                                                    <h5 class="mb-3">
                                                        Msme Udyam Details for MOBILE: <?php echo htmlspecialchars($mobileNumber); ?>
                                                    </h5>
                                                    <table class="table table-bordered table-striped">
                                                        <thead class="table-dark">
                                                            <tr>
                                                                <th>#</th>
                                                                <th>Mobile Number</th>
                                                                <th>Name</th>
                                                                <th>MSME Udyam No</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <?php
                                                            $counter = 1;
                                                            if (!empty($resdata['data']) && is_array($resdata['data'])) {
                                                                foreach ($resdata['data'] as $entry) {
                                                                    echo "<tr>
                                                                        <td>" . $counter++ . "</td>
                                                                        <td>" . htmlspecialchars($mobileNumber) . "</td>
                                                                        <td>" . htmlspecialchars($entry['enterprise_name']) . "</td>
                                                                        <td>" . htmlspecialchars($entry['udyam_number']) . "</td>
                                                                    </tr>";
                                                                }
                                                            } else {
                                                                echo "<tr><td colspan='4' class='text-center text-danger'>No MSME data found</td></tr>";
                                                            }
                                                            ?>
                                                        </tbody>
                                                    </table>
                                                    <div class="text-end mt-3">
                                                        <button class="btn btn-primary" onclick="printDiv('printSection')">
                                                            <i class="fa fa-print"></i> Print / Save PDF
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <?php } ?>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <br><br><br><br>
            </div>
        </div>
    </div>
</div>
<script>
document.addEventListener("DOMContentLoaded", function () {
    const form = document.querySelector("form");
    const submitBtn = document.getElementById("submit");

    let isSubmitting = false;

    form.addEventListener("submit", function (e) {
        if (isSubmitting) {
            e.preventDefault();
            return;
        }
        isSubmitting = true;       
        submitBtn.disabled = true; 
    });
});
</script>
<script>
function printDiv(divId) {
    var printContents = document.getElementById(divId).innerHTML;
    var originalContents = document.body.innerHTML;
    document.body.innerHTML = printContents;
    window.print();
    document.body.innerHTML = originalContents;
}
</script>

<?php include('../template/tngweb/footer.php'); ?>
<script src="../template/tngweb/assets/js/bootstrap.bundle.min.js"></script>
<script src="../template/tngweb/assets/plugins/simplebar/js/simplebar.min.js"></script>
<script src="../template/tngweb/assets/plugins/metismenu/js/metisMenu.min.js"></script>
<script src="../template/tngweb/assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js"></script>
<script src="../template/tngweb/assets/js/app.js"></script>
</html>
